﻿using Microsoft.AspNetCore.Components;
using MyFirstApp.Client.Services;
using Syncfusion.Blazor.Buttons;
using Syncfusion.Blazor.Popups;
using System;
using System.Threading.Tasks;

namespace MyFirstApp.Client.ViewModels
{
    public class ConfirmationComponentViewModel
    {
        private readonly UserService _userService;
        public bool ShowButton { get; set; } = false;
        public bool Visibility { get; set; } = false;
        SfCheckBox<bool> CheckboxObj;
        public EventCallback<bool> OnDeleteEvent { get; set; }


        public ConfirmationComponentViewModel(UserService userService)
        {
            _userService = userService;
        }

        public async Task<string> Delete(string id)
        {
            return await _userService.Delete(id);
        }

        public void DialogOpen(Object args)
        {
            this.ShowButton = false;
        }

        public void DialogClose(Object args)
        {
            this.ShowButton = true;
        }

        public void OnBtnClick()
        {
            this.Visibility = true;
        }

        public void ShowDialog()
        {
            this.Visibility = true;
        }

        public void DlgCancelButtonClick()
        {
            this.Visibility = false;
        }

        public void OverlayClick(OverlayModalClickEventArgs args)
        {
            if ((bool)this.CheckboxObj.Checked)
            {
                this.Visibility = false;
            }
            else
            {
                this.Visibility = true;
            }
        }
    }
}
